﻿#nullable enable
namespace Hims.Api.Models.Practice
{
    using System.Collections.Generic;
    using Shared.EntityModels;

    /// <summary>
    /// The modify practice request.
    /// </summary>
    public class ModifyPracticeRequest
    {
        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        public int PracticeId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public char PracticeType { get; set; }

        /// <summary>
        /// Gets or sets the tin.
        /// </summary>
        public string TIN { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the locations.
        /// </summary>
        public List<PracticeLocationModel>? Locations { get; set; }
        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string ModifiedByName { get; set; }
    }
}
